Assumptions:
1. URL 'localhost' is replaced with correct AMP Resonance Endpoint.
2. Authorization key is replaced with correct AMP Resonance token for the environment you're accessing.

Endpoints:
Development: http://localhost:8083
Staging: 
Resonance: 

Notes:
1. Authorization ApiKey is secret. Treat it like a username / password.
2. Authorization ApiKey can be changed / reset if leaked, but currently it is a manual process that requires contacting AMP developers. If leaked, please reach out rather than using a compromised token.
3. Authorization ApiKey can be locked down to a specific IP. If you are using for production and you have a static IP, this would be ideal but not required at this time.
4. All responses will be either ApiResponse<T> or ApiListResponse<T>, provided you get through authentication / authorization

/****************************************************************************************/
Input:  
curl -v -H 'Content-Type: application/json' -H 'Authorization: ApiKey ABCDEF12345' http://localhost:8083/worker/amp/get-twitch-user-listing-columns

Success Output:
{"success":true,"worker_identifier":"86d756c8e8494f448db58d52ccde1960","request_start_time":"2019-10-01T15:34:28.1003223Z","request_end_time":"2019-10-01T15:34:28.1041141Z","data":["mindate","maxdate","aggregationtype","channelid","login","ccutier","lastbroadcastdate","usertype","usertypechanged","maxccu","averageccu","minuteswatchedtotal","channelconcurrentsminuteswatchedtotal","minutesbroadcasttotal","channelconcurrentsminutesbroadcasttotal","uniquedaysbroadcast","followercounttotal","followercountchangetotal","chatmessagestotal","subssoldtotal","subssoldprimetotal","subssoldtier1total","subssoldtier2total","subssoldtier3total","creatorsubrevenuetotal","creatorprimesubrevenuetotal","creatoradrevenuetotal","creatorbitsrevenuetotal","creatorfuelrevenuetotal","creatorbountyboardrevenuetotal","creatorrevenuetotal","videoplaystotal","primarybroadcastlanguage","primarybroadcastcountry","topgamebroadcast","profileimage","substotal","minuteswatcheddata","averageccudata","region","accountmanager","valuescoreoverallweighted","sort","gamecount","mostviewedplatform","platformpercentwatchedother","platformpercentwatchedmobile","platformpercentwatchedchromecast","platformpercentwatchedweb","platformpercentwatchedconsole","platformpercentwatcheddesktop","ispremium","timsuseractionrequired"]}

Success Fields:
Success: Was the request successful
Worker Identifier: GUID of worker session token. (Mostly used for debugging purposes and not particularly useful for the client)
Request Start Time: Timestamp server received request
Request End Time: Timestamp server finished request
Data: Content returned from request, in this case a string array or columns that can be placed into req-col 

Failure Output:
Bad Token:
*   Trying 127.0.0.1...
* TCP_NODELAY set
* Connected to localhost (127.0.0.1) port 8083 (#0)
> GET /worker/amp/get-twitch-user-listing-columns HTTP/1.1
> Host: localhost:8083
> User-Agent: curl/7.58.0
> Accept: */*
> Authorization: ApiKey ABCDEF1234
>
< HTTP/1.1 302 Found
< Date: Tue, 01 Oct 2019 15:33:42 GMT
< Server: Kestrel
< Content-Length: 0
< Location: /error/403
<
* Connection #0 to host localhost left intact

Bad Request (404):
{"success":false,"worker_identifier":"86d756c8e8494f448db58d52ccde1960","request_start_time":"2019-10-01T15:43:06.8321599Z","request_end_time":null,"data":{"status-code":404,"path":"","error-message":"","request-id":"0HLQ6GCMFKMFR:00000001","show-request-id":true}}

/****************************************************************************************/
Input:  
curl -v -H 'Content-Type: application/json' -H 'Authorization: ApiKey ABCDEF12345' --data '{"limit":10,"page":0,"aggtype":30,"req-cols":["channelid","login","channelconcurrentsminuteswatchedtotal","channelconcurrentsminutesbroadcasttotal","maxccu","averageccu","profileimage"],"req-cols-daily":null,"filters":[{"filter-type":1,"key":"login","is-inclusive":false,"is-case-sensitive":false,"v1":"karma","v2":null,"a1":null}],"sortdata":[{"col":"channelconcurrentsminuteswatchedtotal","ord":0,"asc":false}]}' http://localhost:8083/worker/amp/get-twitch-user-listing
Limit: Max results to return
Page: Offset to start at beginning at 0. 
AggType: Aggregation type. Typically 7/30/60/90/360
Req Cols: Required Columns to return in the data set. These fields are listed in the column listing endpoint
Req cols daily: Required columns that include daily data.
Filters: List of filters to apply against the data.
V1: Value 1 for filter, used for things like exact match.
V2: Only used for filters that use ranges
A1: Array of values to look up, this filter is applied for IN type clauses
Sort: Array of values to sort by
Column: Sort column name as defined in the column listing endpoint
Ordinal: Order to order by (so 0, then 1, then 2, then 3 so you can replicate 'order by x, then y, then z')
Ascending: Whether to return the results in ascending or descending order


Output:
{"success":true,"worker_identifier":"379a0403d4bb478ba620ef04175ee969","request_start_time":"2019-10-01T16:27:34.6169751Z","request_end_time":"2019-10-01T16:27:34.6657627Z","data":[{"channelid":10406,"login":"karma","channelconcurrentsminuteswatchedtotal":6732894,"channelconcurrentsminutesbroadcasttotal":1938,"maxccu":19309,"averageccu":3474.14551,"profileimage":"8510992ed2a77fd9-profile_image-70x70.jpeg"}]}
Success Fields:
Success: Was the request successful
Worker Identifier: GUID of worker session token. (Mostly used for debugging purposes and not particularly useful for the client)
Request Start Time: Timestamp server received request
Request End Time: Timestamp server finished request
Data: Content returned from request, in this case a list of defined req-col data